/*
    This file is part of Google2SRT.

    Google2SRT is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Google2SRT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Google2SRT.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *
 * @author kom
 * @version "0.5.3, 02/03/11"
 */


import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.JFileChooser;



public class GUI extends javax.swing.JFrame {
    TableModel tablemodel;
    java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("Bundle");
    enum tIdioma {ca, es, en, pt_BR, it};
    //private tIdioma idioma = tIdioma.en;
    private String defaultURL = "";
    private String defaultFile = System.getProperty("user.home") +
                                    System.getProperty("file.separator") +
                                    "videotranscript.xml";
    private String defaultFileOut = System.getProperty("user.home") +
                                    System.getProperty("file.separator") +
                                    "output.srt";
    private final JFileChooser fc1 = new JFileChooser(),
                               fc2 = new JFileChooser();
    private List<NetSubtitle> lSubs = null;
    
    /** Creates new form gui */
    public GUI() {
        initComponents();

        this.canviIdioma(tIdioma.en);
        this.jtfFEntrada.setText(defaultURL);
        this.jtfFSortida.setText(defaultFileOut);
        
        fc1.addChoosableFileFilter(new XMLFilter());
        fc2.addChoosableFileFilter(new SRTFilter());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        origenSubs = new javax.swing.ButtonGroup();
        jpmContextual = new javax.swing.JPopupMenu();
        jmiRetallar = new javax.swing.JMenuItem();
        jmiCopiar = new javax.swing.JMenuItem();
        jmiAferrar = new javax.swing.JMenuItem();
        jrbURL = new javax.swing.JRadioButton();
        jrbXML = new javax.swing.JRadioButton();
        jtfFEntrada = new javax.swing.JTextField();
        jtfFSortida = new javax.swing.JTextField();
        jbutFEntrada = new javax.swing.JButton();
        jbutFSortida = new javax.swing.JButton();
        jbutConvertir = new javax.swing.JButton();
        jspinnerRetard = new javax.swing.JSpinner();
        jlSubIn = new javax.swing.JLabel();
        jlSubOut = new javax.swing.JLabel();
        jlRetard = new javax.swing.JLabel();
        jbutCatala = new javax.swing.JButton();
        jbutCastella = new javax.swing.JButton();
        jbutAngles = new javax.swing.JButton();
        jlEstat = new javax.swing.JLabel();
        jcbTot = new javax.swing.JCheckBox();
        jcbInvertir = new javax.swing.JCheckBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        jtLlistaSubtitols = new javax.swing.JTable();
        jbutBrasiler = new javax.swing.JButton();
        jbutItalia = new javax.swing.JButton();

        jmiRetallar.setAction(new javax.swing.text.DefaultEditorKit.CutAction());
        jpmContextual.add(jmiRetallar);

        jmiCopiar.setAction(new javax.swing.text.DefaultEditorKit.CopyAction());
        jpmContextual.add(jmiCopiar);

        jmiAferrar.setAction(new javax.swing.text.DefaultEditorKit.PasteAction());
        jpmContextual.add(jmiAferrar);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle(java.util.ResourceBundle.getBundle("Bundle").getString("app.name") + " " + java.util.ResourceBundle.getBundle("Bundle").getString("app.version"));
        setBounds(new java.awt.Rectangle(0, 0, 0, 0));
        setResizable(false);

        origenSubs.add(jrbURL);
        jrbURL.setSelected(true);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("Bundle"); // NOI18N
        jrbURL.setText(bundle.getString("GUI.jrbURL.text")); // NOI18N
        jrbURL.setToolTipText(bundle.getString("GUI.jrbURL.toolTipText")); // NOI18N
        jrbURL.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jrbURLItemStateChanged(evt);
            }
        });

        origenSubs.add(jrbXML);
        jrbXML.setText(bundle.getString("GUI.jrbXML.text")); // NOI18N
        jrbXML.setToolTipText(bundle.getString("GUI.jrbXML.toolTipText")); // NOI18N
        jrbXML.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jrbXMLItemStateChanged(evt);
            }
        });

        jtfFEntrada.setText(bundle.getString("GUI.jtfFEntrada.text")); // NOI18N
        jtfFEntrada.setToolTipText(bundle.getString("GUI.jtfFEntrada.toolTipText")); // NOI18N
        jtfFEntrada.setComponentPopupMenu(jpmContextual);
        jtfFEntrada.setName("FEntrada"); // NOI18N
        jtfFEntrada.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jtfFEntradaMousePressed(evt);
            }
        });
        jtfFEntrada.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jtfFEntradaFocusGained(evt);
            }
        });

        jtfFSortida.setText(bundle.getString("GUI.jtfFSortida.text")); // NOI18N
        jtfFSortida.setToolTipText(bundle.getString("GUI.jtfFSortida.toolTipText")); // NOI18N
        jtfFSortida.setComponentPopupMenu(jpmContextual);
        jtfFSortida.setName("FSortida"); // NOI18N
        jtfFSortida.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jtfFSortidaMousePressed(evt);
            }
        });

        jbutFEntrada.setText(bundle.getString("GUI.jbutFEntrada.text")); // NOI18N
        jbutFEntrada.setToolTipText(bundle.getString("GUI.jbutFEntrada.toolTipText")); // NOI18N
        jbutFEntrada.setName("bTriaEntrada"); // NOI18N
        jbutFEntrada.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbutFEntradaActionPerformed(evt);
            }
        });

        jbutFSortida.setText(bundle.getString("GUI.jbutFSortida.text")); // NOI18N
        jbutFSortida.setToolTipText(bundle.getString("GUI.jbutFSortida.toolTipText")); // NOI18N
        jbutFSortida.setName("bTriaSortida"); // NOI18N
        jbutFSortida.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbutFSortidaActionPerformed(evt);
            }
        });

        jbutConvertir.setText(bundle.getString("GUI.jbutConvertir.text")); // NOI18N
        jbutConvertir.setToolTipText(bundle.getString("GUI.jbutConvertir.toolTipText")); // NOI18N
        jbutConvertir.setName("Convertir"); // NOI18N
        jbutConvertir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbutConvertirActionPerformed(evt);
            }
        });

        jspinnerRetard.setModel(new javax.swing.SpinnerNumberModel(Double.valueOf(0.0d), null, null, Double.valueOf(0.1d)));
        jspinnerRetard.setToolTipText(bundle.getString("GUI.jspinnerRetard.toolTipText")); // NOI18N
        jspinnerRetard.setName("Retard"); // NOI18N

        jlSubIn.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jlSubIn.setLabelFor(jbutFEntrada);
        jlSubIn.setText(bundle.getString("GUI.jlSubIn.text")); // NOI18N
        jlSubIn.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);

        jlSubOut.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jlSubOut.setLabelFor(jbutFSortida);
        jlSubOut.setText(bundle.getString("GUI.jlSubOut.text")); // NOI18N
        jlSubOut.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);

        jlRetard.setText(bundle.getString("GUI.jlRetard.text")); // NOI18N

        jbutCatala.setFont(new java.awt.Font("Tahoma", 0, 8)); // NOI18N
        jbutCatala.setIcon(new javax.swing.ImageIcon(getClass().getResource("/catalan.jpg"))); // NOI18N
        jbutCatala.setToolTipText(bundle.getString("GUI.jbutCatala.toolTipText")); // NOI18N
        jbutCatala.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbutCatalaActionPerformed(evt);
            }
        });

        jbutCastella.setFont(new java.awt.Font("Tahoma", 0, 8)); // NOI18N
        jbutCastella.setIcon(new javax.swing.ImageIcon(getClass().getResource("/castellano.jpg"))); // NOI18N
        jbutCastella.setToolTipText(bundle.getString("GUI.jbutCastella.toolTipText")); // NOI18N
        jbutCastella.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbutCastellaActionPerformed(evt);
            }
        });

        jbutAngles.setFont(new java.awt.Font("Tahoma", 0, 8)); // NOI18N
        jbutAngles.setIcon(new javax.swing.ImageIcon(getClass().getResource("/ingles.jpg"))); // NOI18N
        jbutAngles.setToolTipText(bundle.getString("GUI.jbutAngles.toolTipText")); // NOI18N
        jbutAngles.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbutAnglesActionPerformed(evt);
            }
        });

        jcbTot.setText(bundle.getString("GUI.jcbTot.text")); // NOI18N
        jcbTot.setToolTipText(bundle.getString("GUI.jcbTot.toolTipText")); // NOI18N
        jcbTot.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jcbTotActionPerformed(evt);
            }
        });

        jcbInvertir.setText(bundle.getString("GUI.jcbInvertir.text")); // NOI18N
        jcbInvertir.setToolTipText(bundle.getString("GUI.jcbInvertir.toolTipText")); // NOI18N
        jcbInvertir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jcbInvertirActionPerformed(evt);
            }
        });

        jtLlistaSubtitols.setModel(new TableModel(java.util.ResourceBundle.getBundle("Bundle")));
        jScrollPane1.setViewportView(jtLlistaSubtitols);

        jbutBrasiler.setFont(new java.awt.Font("Tahoma", 0, 8)); // NOI18N
        jbutBrasiler.setIcon(new javax.swing.ImageIcon(getClass().getResource("/brasileiro.jpg"))); // NOI18N
        jbutBrasiler.setToolTipText(bundle.getString("GUI.jbutBrasiler.toolTipText")); // NOI18N
        jbutBrasiler.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbutBrasilerActionPerformed(evt);
            }
        });

        jbutItalia.setFont(new java.awt.Font("Tahoma", 0, 8)); // NOI18N
        jbutItalia.setIcon(new javax.swing.ImageIcon(getClass().getResource("/italiano.jpg"))); // NOI18N
        jbutItalia.setToolTipText(bundle.getString("GUI.jbutItalia.toolTipText")); // NOI18N
        jbutItalia.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbutItaliaActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGap(192, 192, 192)
                                .addComponent(jrbURL, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jrbXML, javax.swing.GroupLayout.PREFERRED_SIZE, 123, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(layout.createSequentialGroup()
                                .addContainerGap()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jlSubOut)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jcbTot)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jcbInvertir))
                                    .addComponent(jlSubIn)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jbutCatala, javax.swing.GroupLayout.PREFERRED_SIZE, 18, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jbutCastella, javax.swing.GroupLayout.PREFERRED_SIZE, 18, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jbutAngles, javax.swing.GroupLayout.PREFERRED_SIZE, 18, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jbutBrasiler, javax.swing.GroupLayout.PREFERRED_SIZE, 18, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jbutItalia, javax.swing.GroupLayout.PREFERRED_SIZE, 18, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                .addGap(1, 1, 1)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jlRetard)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jspinnerRetard, javax.swing.GroupLayout.PREFERRED_SIZE, 91, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(jtfFEntrada, javax.swing.GroupLayout.PREFERRED_SIZE, 332, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(jtfFSortida, javax.swing.GroupLayout.PREFERRED_SIZE, 332, javax.swing.GroupLayout.PREFERRED_SIZE)))))
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jbutFEntrada, javax.swing.GroupLayout.DEFAULT_SIZE, 131, Short.MAX_VALUE)
                            .addComponent(jbutConvertir, javax.swing.GroupLayout.DEFAULT_SIZE, 131, Short.MAX_VALUE)
                            .addComponent(jbutFSortida, javax.swing.GroupLayout.DEFAULT_SIZE, 131, Short.MAX_VALUE)))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 596, Short.MAX_VALUE)
                            .addComponent(jlEstat, javax.swing.GroupLayout.DEFAULT_SIZE, 596, Short.MAX_VALUE))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jrbURL)
                    .addComponent(jrbXML))
                .addGap(3, 3, 3)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jlSubIn)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jtfFEntrada, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jbutFEntrada)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jtfFSortida, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jbutFSortida)
                    .addComponent(jlSubOut))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jlRetard)
                        .addComponent(jspinnerRetard, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jbutConvertir))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jbutBrasiler, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jbutCatala, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jbutCastella, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jbutAngles, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jbutItalia, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jcbTot)
                            .addComponent(jcbInvertir))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 127, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jlEstat, javax.swing.GroupLayout.PREFERRED_SIZE, 18, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void canviIdioma (tIdioma a) {
        //this.idioma = a;
        String s;
        s = a.toString();
        
        if (s == null)
            bundle = java.util.ResourceBundle.getBundle("Bundle");
        else
            try { bundle = java.util.ResourceBundle.getBundle("Bundle_" + s); } // s.toLowerCase()
            catch (Exception e) { bundle = java.util.ResourceBundle.getBundle("Bundle"); }


        if (this.jrbURL.isSelected()) {
            this.jbutFEntrada.setText(bundle.getString("GUI.jbutFEntrada.text"));
            this.jbutFEntrada.setToolTipText(bundle.getString("GUI.jbutFEntrada.toolTipText"));
        } else {
            this.jbutFEntrada.setText(bundle.getString("GUI.jbutFEntrada.xmlfile.text"));
            this.jbutFEntrada.setToolTipText(bundle.getString("GUI.jbutFEntrada.xmlfile.toolTipText"));
        }

        this.jlSubIn.setText(bundle.getString("GUI.jlSubIn.text"));
        this.jlSubOut.setText(bundle.getString("GUI.jlSubOut.text"));
        this.jlRetard.setText(bundle.getString("GUI.jlRetard.text"));
        this.jbutFSortida.setText(bundle.getString("GUI.jbutFSortida.text"));
        this.jbutFSortida.setToolTipText(bundle.getString("GUI.jbutFSortida.toolTipText"));
        this.jbutConvertir.setText(bundle.getString("GUI.jbutConvertir.text"));
        this.jbutConvertir.setToolTipText(bundle.getString("GUI.jbutConvertir.toolTipText"));
        this.jtfFEntrada.setToolTipText(bundle.getString("GUI.jtfFEntrada.toolTipText"));
        this.jtfFSortida.setToolTipText(bundle.getString("GUI.jtfFSortida.toolTipText"));
        this.jrbXML.setText(bundle.getString("GUI.jrbXML.text"));
        this.jrbXML.setToolTipText(bundle.getString("GUI.jrbXML.toolTipText"));
        this.jrbURL.setText(bundle.getString("GUI.jrbURL.text"));
        this.jrbURL.setToolTipText(bundle.getString("GUI.jrbURL.toolTipText"));
        this.jspinnerRetard.setToolTipText(bundle.getString("GUI.jspinnerRetard.toolTipText"));
        this.jcbInvertir.setText(bundle.getString("GUI.jcbInvertir.text"));
        this.jcbInvertir.setToolTipText(bundle.getString("GUI.jcbInvertir.toolTipText"));
        this.jcbTot.setText(bundle.getString("GUI.jcbTot.text"));
        this.jcbTot.setToolTipText(bundle.getString("GUI.jcbTot.toolTipText"));
        this.jmiRetallar.setText(bundle.getString("GUI.jmiRetallar.text"));
        this.jmiCopiar.setText(bundle.getString("GUI.jmiCopiar.text"));
        this.jmiAferrar.setText(bundle.getString("GUI.jmiAferrar.text"));

        Object data[][];
        if (this.tablemodel != null)
            data = this.tablemodel.getData();
        else
            data = null;
        this.tablemodel = new TableModel(bundle);
        if (lSubs != null) {
            if (data != null)
                this.tablemodel.init(lSubs, data);
            else
                this.tablemodel.init(lSubs);
        }
        this.jtLlistaSubtitols.setModel(tablemodel);

    }
    
    private void jbutConvertirActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbutConvertirActionPerformed
        String msg;
        InputStreamReader entrada = null;
        Converter conv;
        boolean sel_un = false;
        Object data[][];
        String afegitNom, s;
        
        this.jbutConvertir.setEnabled(false);
        if (! this.jrbURL.isSelected()) { // volem seleccionar un fitxer
            if ("".equals(jtfFEntrada.getText())) {
                msg = bundle.getString("msg.infile.not.specified");
                javax.swing.JOptionPane.showMessageDialog(null, msg);
                jtfFEntrada.requestFocusInWindow();
                preparaNova();
                return;
            }
            try {
                entrada = new InputStreamReader(new FileInputStream(jtfFEntrada.getText()), "UTF-8");
            } catch (FileNotFoundException ex) {
                this.msgIOException();
                preparaNova();
                return;
            } catch (java.io.UnsupportedEncodingException ex) {
                System.out.println("DEBUG: encoding not supported");
            }
        } else { // llegir des de xarxa...
            if (lSubs == null) {
                recuperaSubs();
                return;
            }
        }
        
        if ("".equals(jtfFSortida.getText())) {
            msg = bundle.getString("msg.outfile.not.specified");
            javax.swing.JOptionPane.showMessageDialog(null, msg);
            jtfFSortida.requestFocusInWindow();
            preparaNova();
            return;
        }

        msg = bundle.getString("msg.status.converting");
        
        if ((entrada != null) && (this.lSubs == null)) { // fitxer xml (local)
            conv = new Converter(this,
                    entrada,
                    jtfFSortida.getText(),
                    ((Double)jspinnerRetard.getValue()).doubleValue());
            conv.run();
            preparaNova();
            msgConversioFi();
        } else if (this.lSubs != null) { // llista xml (xarxa)

            data = this.tablemodel.getData();

            for (int i = 0; i < data.length; i++) {
          
                if (((Boolean) data[i][0]).booleanValue()) {
                    sel_un = true;
                    try {
                        entrada = Network.readURL(this.lSubs.get(i).getTrackURL());
                    } catch (MalformedURLException ex) {
                        System.out.println("DEBUG: URL errònia");
                    } catch (IOException ex) {
                        System.out.println("DEBUG: No s'ha pogut llegir (??)");
                    }
                    
                    afegitNom = "_";
                    afegitNom += this.lSubs.get(i).getIdXML();
                    s = this.lSubs.get(i).getName();
                    if (s != null)
                        afegitNom += "_" + s;
                    s = this.lSubs.get(i).getLang();
                    if (s != null)
                        afegitNom += "_" + s;
                    afegitNom += ".srt";
                    
                    conv = new Converter(
                        this,
                        entrada,
                        Common.removeExtension(jtfFSortida.getText()) + afegitNom,
                        ((Double)jspinnerRetard.getValue()).doubleValue());
                    conv.run();
                }

            }
            if (! sel_un) { // no hi ha selecció
                preparaNova();
                msg = bundle.getString("msg.sublist.none.selected");
                javax.swing.JOptionPane.showMessageDialog(null, msg);
            } else { // s'ha seleccionat i acabat de processar (correctament o no)
                preparaNova();
                msgConversioFi();
            }
        }
    }//GEN-LAST:event_jbutConvertirActionPerformed

    private void jbutFEntradaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbutFEntradaActionPerformed
        int returnVal;
        
        if (this.jrbXML.isSelected()) { // comportament fitxer XML
            returnVal = fc1.showOpenDialog(this.getParent());
            if (returnVal == JFileChooser.APPROVE_OPTION)
                jtfFEntrada.setText(fc1.getSelectedFile().getAbsolutePath());
        } else { // comportament URL
            recuperaSubs();
        }
    }//GEN-LAST:event_jbutFEntradaActionPerformed

    private void jbutFSortidaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbutFSortidaActionPerformed
        int returnVal;
                
        returnVal = fc2.showSaveDialog(this.getParent());
        if (returnVal == JFileChooser.APPROVE_OPTION)
            jtfFSortida.setText(fc2.getSelectedFile().getAbsolutePath());
    }//GEN-LAST:event_jbutFSortidaActionPerformed

    private void jbutCatalaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbutCatalaActionPerformed
        this.canviIdioma(tIdioma.ca);
}//GEN-LAST:event_jbutCatalaActionPerformed

    private void jbutCastellaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbutCastellaActionPerformed
        this.canviIdioma(tIdioma.es);
    }//GEN-LAST:event_jbutCastellaActionPerformed

    private void jbutAnglesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbutAnglesActionPerformed
        this.canviIdioma(tIdioma.en);
    }//GEN-LAST:event_jbutAnglesActionPerformed

private void jtfFEntradaFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jtfFEntradaFocusGained
    this.jtfFEntrada.selectAll();
}//GEN-LAST:event_jtfFEntradaFocusGained

private void jcbInvertirActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jcbInvertirActionPerformed
    int i;
    Object data[][];

    this.jcbInvertir.setSelected(false);
    data = this.tablemodel.getData();
    if (data == null) return;
    for (i = 0; i < data.length; i++)
        data[i][0] = new Boolean(!((Boolean) data[i][0]).booleanValue());
    this.tablemodel = new TableModel(bundle);
    this.tablemodel.init(lSubs, data);
    this.jtLlistaSubtitols.setModel(tablemodel);

}//GEN-LAST:event_jcbInvertirActionPerformed

private void jcbTotActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jcbTotActionPerformed
    int i;
    Object data[][];

    data = this.tablemodel.getData();
    if (data == null) return;
    for (i = 0; i < data.length; i++)
        data[i][0] = new Boolean(this.jcbTot.isSelected());
    this.tablemodel = new TableModel(bundle);
    this.tablemodel.init(lSubs, data);
    this.jtLlistaSubtitols.setModel(tablemodel);
}//GEN-LAST:event_jcbTotActionPerformed

private void jrbURLItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jrbURLItemStateChanged

    if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED) {
        defaultFile = this.jtfFEntrada.getText();
        this.jtfFEntrada.setText(defaultURL);

        this.jbutFEntrada.setText(bundle.getString("GUI.jbutFEntrada.text"));
        this.jbutFEntrada.setToolTipText(bundle.getString("GUI.jbutFEntrada.toolTipText"));
    }
}//GEN-LAST:event_jrbURLItemStateChanged

private void jrbXMLItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jrbXMLItemStateChanged

    if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED) {
        this.lSubs = null; // buida llista netsubs (subtítols)
        defaultURL = this.jtfFEntrada.getText();
        this.jtfFEntrada.setText(defaultFile);

        this.jbutFEntrada.setText(bundle.getString("GUI.jbutFEntrada.xmlfile.text"));
        this.jbutFEntrada.setToolTipText(bundle.getString("GUI.jbutFEntrada.xmlfile.toolTipText"));
    }
}//GEN-LAST:event_jrbXMLItemStateChanged

private void jtfFEntradaMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jtfFEntradaMousePressed

    if (evt.getButton() == java.awt.event.MouseEvent.BUTTON3) {
        this.jtfFEntrada.requestFocusInWindow();
    }

}//GEN-LAST:event_jtfFEntradaMousePressed

private void jtfFSortidaMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jtfFSortidaMousePressed

    if (evt.getButton() == java.awt.event.MouseEvent.BUTTON3) {
        this.jtfFSortida.requestFocusInWindow();
    }
    
}//GEN-LAST:event_jtfFSortidaMousePressed

private void jbutBrasilerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbutBrasilerActionPerformed
    this.canviIdioma(tIdioma.pt_BR);
}//GEN-LAST:event_jbutBrasilerActionPerformed

    private void jbutItaliaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbutItaliaActionPerformed
        this.canviIdioma(tIdioma.it);
    }//GEN-LAST:event_jbutItaliaActionPerformed


    
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new GUI().setVisible(true);
            }
        });
    }
    
    public void msgFormatEntradaNoValid() {
        String msg;

        msg = bundle.getString("msg.infile.invalid.format");
        jtfFEntrada.requestFocusInWindow();
        javax.swing.JOptionPane.showMessageDialog(null, msg);
    }

    public void msgIOException() {
        String msg;

        msg = bundle.getString("msg.io.error");
        jtfFEntrada.requestFocusInWindow();
        javax.swing.JOptionPane.showMessageDialog(null, msg);
    }
    
    public void msgFitxerNoSubtitols() {
        String msg;

        msg = bundle.getString("msg.infile.no.subtitles.found");
        jtfFEntrada.requestFocusInWindow();
        javax.swing.JOptionPane.showMessageDialog(null, msg);
    }

    public void msgConversioOk() {
        String msg;

        msg = bundle.getString("msg.convesion.done.ok");
        jtfFEntrada.requestFocusInWindow();
        javax.swing.JOptionPane.showMessageDialog(null, msg);
    }
    
    public void msgConversioFi() { // ha acabat (correctament o no)
        String msg;

        msg = bundle.getString("msg.convesion.finished");
        jtfFEntrada.requestFocusInWindow();
        javax.swing.JOptionPane.showMessageDialog(null, msg);
    }
    
    public void msgConversioErrors() {
        String msg;

        msg = bundle.getString("msg.convesion.done.error");
        jtfFEntrada.requestFocusInWindow();
        javax.swing.JOptionPane.showMessageDialog(null, msg);
    }
    
    public void preparaNova() {
        this.jbutConvertir.setEnabled(true);
        this.jlEstat.setText("");
    }

    public void recuperaSubs() {
        String msg;
        
        this.lSubs = null; // buida llista netsubs (subtítols)
        this.jcbTot.setSelected(false);

       // comprovam validesa de l'URL
        try {
            this.jlEstat.setText(bundle.getString("msg.status.connecting"));
            lSubs = Network.getSubtitles(this.jtfFEntrada.getText());
            this.jlEstat.setText("");
        } catch (Network.HostNoGV e) {
            msg = bundle.getString("msg.url.unknown.host");
            jtfFEntrada.requestFocusInWindow();
            javax.swing.JOptionPane.showMessageDialog(null, msg);
            preparaNova();
            return;
        } catch (Network.NoDocId e) {
            msg = bundle.getString("msg.url.parameter.docid.not.found");
            jtfFEntrada.requestFocusInWindow();
            javax.swing.JOptionPane.showMessageDialog(null, msg);
            preparaNova();
            return;
        } catch (Network.NoQuery e) {
            msg = bundle.getString("msg.url.parameter.not.found");
            jtfFEntrada.requestFocusInWindow();
            javax.swing.JOptionPane.showMessageDialog(null, msg);
            preparaNova();
            return;
        } catch (Network.DocIdInvalid e) {
            msg = bundle.getString("msg.url.parameter.docid.invalid");
            jtfFEntrada.requestFocusInWindow();
            javax.swing.JOptionPane.showMessageDialog(null, msg);
            preparaNova();
            return;
        } catch (Network.NoSubs e) {
            this.msgFitxerNoSubtitols();
            preparaNova();
            return;
        } catch (MalformedURLException e) {
            msg = bundle.getString("msg.url.invalid.format");
            jtfFEntrada.requestFocusInWindow();
            javax.swing.JOptionPane.showMessageDialog(null, msg);
            preparaNova();
            return;
        } catch (org.jdom.input.JDOMParseException e) {
            msg = bundle.getString("msg.url.unexpected.format");
            jtfFEntrada.requestFocusInWindow();
            javax.swing.JOptionPane.showMessageDialog(null, msg);
            preparaNova();
            return;
        } catch (java.net.UnknownHostException e) {
            msg = bundle.getString("msg.net.unknown.host");
            jtfFEntrada.requestFocusInWindow();
            javax.swing.JOptionPane.showMessageDialog(null, msg);
            preparaNova();
            return;
        } catch (java.io.FileNotFoundException e) {
            msg = bundle.getString("msg.url.does.not.exist");
            jtfFEntrada.requestFocusInWindow();
            javax.swing.JOptionPane.showMessageDialog(null, msg);
            preparaNova();
        } catch (Exception e) {
            e.printStackTrace();
            msg = bundle.getString("msg.unknown.error");
            jtfFEntrada.requestFocusInWindow();
            javax.swing.JOptionPane.showMessageDialog(null, msg);
            preparaNova();
            return;
        }
        // ha anat bé

        this.tablemodel = new TableModel(bundle);
        if (lSubs != null) {
            Object data[][];
            data = this.tablemodel.getData();
            if (data != null)
                this.tablemodel.init(lSubs, data);
            else
                this.tablemodel.init(lSubs);
        }
        this.jtLlistaSubtitols.setModel(tablemodel);
        preparaNova();

    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton jbutAngles;
    private javax.swing.JButton jbutBrasiler;
    private javax.swing.JButton jbutCastella;
    private javax.swing.JButton jbutCatala;
    private javax.swing.JButton jbutConvertir;
    private javax.swing.JButton jbutFEntrada;
    private javax.swing.JButton jbutFSortida;
    private javax.swing.JButton jbutItalia;
    private javax.swing.JCheckBox jcbInvertir;
    private javax.swing.JCheckBox jcbTot;
    private javax.swing.JLabel jlEstat;
    private javax.swing.JLabel jlRetard;
    private javax.swing.JLabel jlSubIn;
    private javax.swing.JLabel jlSubOut;
    private javax.swing.JMenuItem jmiAferrar;
    private javax.swing.JMenuItem jmiCopiar;
    private javax.swing.JMenuItem jmiRetallar;
    private javax.swing.JPopupMenu jpmContextual;
    private javax.swing.JRadioButton jrbURL;
    private javax.swing.JRadioButton jrbXML;
    private javax.swing.JSpinner jspinnerRetard;
    private javax.swing.JTable jtLlistaSubtitols;
    private javax.swing.JTextField jtfFEntrada;
    private javax.swing.JTextField jtfFSortida;
    private javax.swing.ButtonGroup origenSubs;
    // End of variables declaration//GEN-END:variables
    
}
