/*
 * Decompiled with CFR 0.152.
 */
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultEditorKit;
import org.jdom.input.JDOMParseException;

public class GUI
extends JFrame {
    TableModel tablemodel;
    ResourceBundle bundle = ResourceBundle.getBundle("Bundle");
    private String defaultURL = "";
    private String defaultFile = System.getProperty("user.home") + System.getProperty("file.separator") + "videotranscript.xml";
    private String defaultFileOut = System.getProperty("user.home") + System.getProperty("file.separator") + "output.srt";
    private final JFileChooser fc1 = new JFileChooser();
    private final JFileChooser fc2 = new JFileChooser();
    private List<NetSubtitle> lSubs = null;
    private JScrollPane jScrollPane1;
    private JButton jbutAngles;
    private JButton jbutBrasiler;
    private JButton jbutCastella;
    private JButton jbutCatala;
    private JButton jbutConvertir;
    private JButton jbutFEntrada;
    private JButton jbutFSortida;
    private JButton jbutItalia;
    private JCheckBox jcbInvertir;
    private JCheckBox jcbTot;
    private JLabel jlEstat;
    private JLabel jlRetard;
    private JLabel jlSubIn;
    private JLabel jlSubOut;
    private JMenuItem jmiAferrar;
    private JMenuItem jmiCopiar;
    private JMenuItem jmiRetallar;
    private JPopupMenu jpmContextual;
    private JRadioButton jrbURL;
    private JRadioButton jrbXML;
    private JSpinner jspinnerRetard;
    private JTable jtLlistaSubtitols;
    private JTextField jtfFEntrada;
    private JTextField jtfFSortida;
    private ButtonGroup origenSubs;

    public GUI() {
        this.initComponents();
        this.canviIdioma(tIdioma.en);
        this.jtfFEntrada.setText(this.defaultURL);
        this.jtfFSortida.setText(this.defaultFileOut);
        this.fc1.addChoosableFileFilter(new XMLFilter());
        this.fc2.addChoosableFileFilter(new SRTFilter());
    }

    private void initComponents() {
        this.origenSubs = new ButtonGroup();
        this.jpmContextual = new JPopupMenu();
        this.jmiRetallar = new JMenuItem();
        this.jmiCopiar = new JMenuItem();
        this.jmiAferrar = new JMenuItem();
        this.jrbURL = new JRadioButton();
        this.jrbXML = new JRadioButton();
        this.jtfFEntrada = new JTextField();
        this.jtfFSortida = new JTextField();
        this.jbutFEntrada = new JButton();
        this.jbutFSortida = new JButton();
        this.jbutConvertir = new JButton();
        this.jspinnerRetard = new JSpinner();
        this.jlSubIn = new JLabel();
        this.jlSubOut = new JLabel();
        this.jlRetard = new JLabel();
        this.jbutCatala = new JButton();
        this.jbutCastella = new JButton();
        this.jbutAngles = new JButton();
        this.jlEstat = new JLabel();
        this.jcbTot = new JCheckBox();
        this.jcbInvertir = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jtLlistaSubtitols = new JTable();
        this.jbutBrasiler = new JButton();
        this.jbutItalia = new JButton();
        this.jmiRetallar.setAction(new DefaultEditorKit.CutAction());
        this.jpmContextual.add(this.jmiRetallar);
        this.jmiCopiar.setAction(new DefaultEditorKit.CopyAction());
        this.jpmContextual.add(this.jmiCopiar);
        this.jmiAferrar.setAction(new DefaultEditorKit.PasteAction());
        this.jpmContextual.add(this.jmiAferrar);
        this.setDefaultCloseOperation(3);
        this.setTitle(ResourceBundle.getBundle("Bundle").getString("app.name") + " " + ResourceBundle.getBundle("Bundle").getString("app.version"));
        this.setBounds(new Rectangle(0, 0, 0, 0));
        this.setResizable(false);
        this.origenSubs.add(this.jrbURL);
        this.jrbURL.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("Bundle");
        this.jrbURL.setText(bundle.getString("GUI.jrbURL.text"));
        this.jrbURL.setToolTipText(bundle.getString("GUI.jrbURL.toolTipText"));
        this.jrbURL.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GUI.this.jrbURLItemStateChanged(evt);
            }
        });
        this.origenSubs.add(this.jrbXML);
        this.jrbXML.setText(bundle.getString("GUI.jrbXML.text"));
        this.jrbXML.setToolTipText(bundle.getString("GUI.jrbXML.toolTipText"));
        this.jrbXML.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GUI.this.jrbXMLItemStateChanged(evt);
            }
        });
        this.jtfFEntrada.setText(bundle.getString("GUI.jtfFEntrada.text"));
        this.jtfFEntrada.setToolTipText(bundle.getString("GUI.jtfFEntrada.toolTipText"));
        this.jtfFEntrada.setComponentPopupMenu(this.jpmContextual);
        this.jtfFEntrada.setName("FEntrada");
        this.jtfFEntrada.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GUI.this.jtfFEntradaMousePressed(evt);
            }
        });
        this.jtfFEntrada.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                GUI.this.jtfFEntradaFocusGained(evt);
            }
        });
        this.jtfFSortida.setText(bundle.getString("GUI.jtfFSortida.text"));
        this.jtfFSortida.setToolTipText(bundle.getString("GUI.jtfFSortida.toolTipText"));
        this.jtfFSortida.setComponentPopupMenu(this.jpmContextual);
        this.jtfFSortida.setName("FSortida");
        this.jtfFSortida.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                GUI.this.jtfFSortidaMousePressed(evt);
            }
        });
        this.jbutFEntrada.setText(bundle.getString("GUI.jbutFEntrada.text"));
        this.jbutFEntrada.setToolTipText(bundle.getString("GUI.jbutFEntrada.toolTipText"));
        this.jbutFEntrada.setName("bTriaEntrada");
        this.jbutFEntrada.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jbutFEntradaActionPerformed(evt);
            }
        });
        this.jbutFSortida.setText(bundle.getString("GUI.jbutFSortida.text"));
        this.jbutFSortida.setToolTipText(bundle.getString("GUI.jbutFSortida.toolTipText"));
        this.jbutFSortida.setName("bTriaSortida");
        this.jbutFSortida.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jbutFSortidaActionPerformed(evt);
            }
        });
        this.jbutConvertir.setText(bundle.getString("GUI.jbutConvertir.text"));
        this.jbutConvertir.setToolTipText(bundle.getString("GUI.jbutConvertir.toolTipText"));
        this.jbutConvertir.setName("Convertir");
        this.jbutConvertir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jbutConvertirActionPerformed(evt);
            }
        });
        this.jspinnerRetard.setModel(new SpinnerNumberModel((Number)0.0, null, null, (Number)0.1));
        this.jspinnerRetard.setToolTipText(bundle.getString("GUI.jspinnerRetard.toolTipText"));
        this.jspinnerRetard.setName("Retard");
        this.jlSubIn.setHorizontalAlignment(4);
        this.jlSubIn.setLabelFor(this.jbutFEntrada);
        this.jlSubIn.setText(bundle.getString("GUI.jlSubIn.text"));
        this.jlSubIn.setHorizontalTextPosition(4);
        this.jlSubOut.setHorizontalAlignment(4);
        this.jlSubOut.setLabelFor(this.jbutFSortida);
        this.jlSubOut.setText(bundle.getString("GUI.jlSubOut.text"));
        this.jlSubOut.setHorizontalTextPosition(4);
        this.jlRetard.setText(bundle.getString("GUI.jlRetard.text"));
        this.jbutCatala.setFont(new Font("Tahoma", 0, 8));
        this.jbutCatala.setIcon(new ImageIcon(this.getClass().getResource("/catalan.jpg")));
        this.jbutCatala.setToolTipText(bundle.getString("GUI.jbutCatala.toolTipText"));
        this.jbutCatala.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jbutCatalaActionPerformed(evt);
            }
        });
        this.jbutCastella.setFont(new Font("Tahoma", 0, 8));
        this.jbutCastella.setIcon(new ImageIcon(this.getClass().getResource("/castellano.jpg")));
        this.jbutCastella.setToolTipText(bundle.getString("GUI.jbutCastella.toolTipText"));
        this.jbutCastella.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jbutCastellaActionPerformed(evt);
            }
        });
        this.jbutAngles.setFont(new Font("Tahoma", 0, 8));
        this.jbutAngles.setIcon(new ImageIcon(this.getClass().getResource("/ingles.jpg")));
        this.jbutAngles.setToolTipText(bundle.getString("GUI.jbutAngles.toolTipText"));
        this.jbutAngles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jbutAnglesActionPerformed(evt);
            }
        });
        this.jcbTot.setText(bundle.getString("GUI.jcbTot.text"));
        this.jcbTot.setToolTipText(bundle.getString("GUI.jcbTot.toolTipText"));
        this.jcbTot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jcbTotActionPerformed(evt);
            }
        });
        this.jcbInvertir.setText(bundle.getString("GUI.jcbInvertir.text"));
        this.jcbInvertir.setToolTipText(bundle.getString("GUI.jcbInvertir.toolTipText"));
        this.jcbInvertir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jcbInvertirActionPerformed(evt);
            }
        });
        this.jtLlistaSubtitols.setModel(new TableModel(ResourceBundle.getBundle("Bundle")));
        this.jScrollPane1.setViewportView(this.jtLlistaSubtitols);
        this.jbutBrasiler.setFont(new Font("Tahoma", 0, 8));
        this.jbutBrasiler.setIcon(new ImageIcon(this.getClass().getResource("/brasileiro.jpg")));
        this.jbutBrasiler.setToolTipText(bundle.getString("GUI.jbutBrasiler.toolTipText"));
        this.jbutBrasiler.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jbutBrasilerActionPerformed(evt);
            }
        });
        this.jbutItalia.setFont(new Font("Tahoma", 0, 8));
        this.jbutItalia.setIcon(new ImageIcon(this.getClass().getResource("/italiano.jpg")));
        this.jbutItalia.setToolTipText(bundle.getString("GUI.jbutItalia.toolTipText"));
        this.jbutItalia.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.jbutItaliaActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(192, 192, 192).addComponent(this.jrbURL, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jrbXML, -2, 123, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlSubOut).addGroup(layout.createSequentialGroup().addComponent(this.jcbTot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcbInvertir)).addComponent(this.jlSubIn).addGroup(layout.createSequentialGroup().addComponent(this.jbutCatala, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbutCastella, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbutAngles, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbutBrasiler, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbutItalia, -2, 18, -2))).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jlRetard).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jspinnerRetard, -2, 91, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jtfFEntrada, -2, 332, -2).addComponent(this.jtfFSortida, -2, 332, -2))))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jbutFEntrada, -1, 131, Short.MAX_VALUE).addComponent(this.jbutConvertir, -1, 131, Short.MAX_VALUE).addComponent(this.jbutFSortida, -1, 131, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 596, Short.MAX_VALUE).addComponent(this.jlEstat, -1, 596, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jrbURL).addComponent(this.jrbXML)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlSubIn).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jtfFEntrada, -2, -1, -2).addComponent(this.jbutFEntrada))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jtfFSortida, -2, -1, -2).addComponent(this.jbutFSortida).addComponent(this.jlSubOut)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jlRetard).addComponent(this.jspinnerRetard, -2, -1, -2).addComponent(this.jbutConvertir)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jbutBrasiler, -2, 14, -2).addComponent(this.jbutCatala, -2, 14, -2).addComponent(this.jbutCastella, -2, 14, -2).addComponent(this.jbutAngles, -2, 14, -2).addComponent(this.jbutItalia, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jcbTot).addComponent(this.jcbInvertir)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 127, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlEstat, -2, 18, -2).addContainerGap()));
        this.pack();
    }

    private void canviIdioma(tIdioma a) {
        String s = a.toString();
        if (s == null) {
            this.bundle = ResourceBundle.getBundle("Bundle");
        } else {
            try {
                this.bundle = ResourceBundle.getBundle("Bundle_" + s);
            }
            catch (Exception e) {
                this.bundle = ResourceBundle.getBundle("Bundle");
            }
        }
        if (this.jrbURL.isSelected()) {
            this.jbutFEntrada.setText(this.bundle.getString("GUI.jbutFEntrada.text"));
            this.jbutFEntrada.setToolTipText(this.bundle.getString("GUI.jbutFEntrada.toolTipText"));
        } else {
            this.jbutFEntrada.setText(this.bundle.getString("GUI.jbutFEntrada.xmlfile.text"));
            this.jbutFEntrada.setToolTipText(this.bundle.getString("GUI.jbutFEntrada.xmlfile.toolTipText"));
        }
        this.jlSubIn.setText(this.bundle.getString("GUI.jlSubIn.text"));
        this.jlSubOut.setText(this.bundle.getString("GUI.jlSubOut.text"));
        this.jlRetard.setText(this.bundle.getString("GUI.jlRetard.text"));
        this.jbutFSortida.setText(this.bundle.getString("GUI.jbutFSortida.text"));
        this.jbutFSortida.setToolTipText(this.bundle.getString("GUI.jbutFSortida.toolTipText"));
        this.jbutConvertir.setText(this.bundle.getString("GUI.jbutConvertir.text"));
        this.jbutConvertir.setToolTipText(this.bundle.getString("GUI.jbutConvertir.toolTipText"));
        this.jtfFEntrada.setToolTipText(this.bundle.getString("GUI.jtfFEntrada.toolTipText"));
        this.jtfFSortida.setToolTipText(this.bundle.getString("GUI.jtfFSortida.toolTipText"));
        this.jrbXML.setText(this.bundle.getString("GUI.jrbXML.text"));
        this.jrbXML.setToolTipText(this.bundle.getString("GUI.jrbXML.toolTipText"));
        this.jrbURL.setText(this.bundle.getString("GUI.jrbURL.text"));
        this.jrbURL.setToolTipText(this.bundle.getString("GUI.jrbURL.toolTipText"));
        this.jspinnerRetard.setToolTipText(this.bundle.getString("GUI.jspinnerRetard.toolTipText"));
        this.jcbInvertir.setText(this.bundle.getString("GUI.jcbInvertir.text"));
        this.jcbInvertir.setToolTipText(this.bundle.getString("GUI.jcbInvertir.toolTipText"));
        this.jcbTot.setText(this.bundle.getString("GUI.jcbTot.text"));
        this.jcbTot.setToolTipText(this.bundle.getString("GUI.jcbTot.toolTipText"));
        this.jmiRetallar.setText(this.bundle.getString("GUI.jmiRetallar.text"));
        this.jmiCopiar.setText(this.bundle.getString("GUI.jmiCopiar.text"));
        this.jmiAferrar.setText(this.bundle.getString("GUI.jmiAferrar.text"));
        Object[][] data = this.tablemodel != null ? this.tablemodel.getData() : (Object[][])null;
        this.tablemodel = new TableModel(this.bundle);
        if (this.lSubs != null) {
            if (data != null) {
                this.tablemodel.init(this.lSubs, data);
            } else {
                this.tablemodel.init(this.lSubs);
            }
        }
        this.jtLlistaSubtitols.setModel(this.tablemodel);
    }

    private void jbutConvertirActionPerformed(ActionEvent evt) {
        InputStreamReader entrada = null;
        boolean sel_un = false;
        this.jbutConvertir.setEnabled(false);
        if (!this.jrbURL.isSelected()) {
            if ("".equals(this.jtfFEntrada.getText())) {
                String msg = this.bundle.getString("msg.infile.not.specified");
                JOptionPane.showMessageDialog(null, msg);
                this.jtfFEntrada.requestFocusInWindow();
                this.preparaNova();
                return;
            }
            try {
                entrada = new InputStreamReader((InputStream)new FileInputStream(this.jtfFEntrada.getText()), "UTF-8");
            }
            catch (FileNotFoundException ex) {
                this.msgIOException();
                this.preparaNova();
                return;
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("DEBUG: encoding not supported");
            }
        } else if (this.lSubs == null) {
            this.recuperaSubs();
            return;
        }
        if ("".equals(this.jtfFSortida.getText())) {
            String msg = this.bundle.getString("msg.outfile.not.specified");
            JOptionPane.showMessageDialog(null, msg);
            this.jtfFSortida.requestFocusInWindow();
            this.preparaNova();
            return;
        }
        String msg = this.bundle.getString("msg.status.converting");
        if (entrada != null && this.lSubs == null) {
            Converter conv = new Converter(this, entrada, this.jtfFSortida.getText(), (Double)this.jspinnerRetard.getValue());
            conv.run();
            this.preparaNova();
            this.msgConversioFi();
        } else if (this.lSubs != null) {
            Object[][] data = this.tablemodel.getData();
            for (int i = 0; i < data.length; ++i) {
                if (!((Boolean)data[i][0]).booleanValue()) continue;
                sel_un = true;
                try {
                    entrada = Network.readURL(this.lSubs.get(i).getTrackURL());
                }
                catch (MalformedURLException ex) {
                    System.out.println("DEBUG: URL err\u00f2nia");
                }
                catch (IOException ex) {
                    System.out.println("DEBUG: No s'ha pogut llegir (??)");
                }
                String afegitNom = "_";
                afegitNom = afegitNom + this.lSubs.get(i).getIdXML();
                String s = this.lSubs.get(i).getName();
                if (s != null) {
                    afegitNom = afegitNom + "_" + s;
                }
                if ((s = this.lSubs.get(i).getLang()) != null) {
                    afegitNom = afegitNom + "_" + s;
                }
                afegitNom = afegitNom + ".srt";
                Converter conv = new Converter(this, entrada, Common.removeExtension(this.jtfFSortida.getText()) + afegitNom, (Double)this.jspinnerRetard.getValue());
                conv.run();
            }
            if (!sel_un) {
                this.preparaNova();
                msg = this.bundle.getString("msg.sublist.none.selected");
                JOptionPane.showMessageDialog(null, msg);
            } else {
                this.preparaNova();
                this.msgConversioFi();
            }
        }
    }

    private void jbutFEntradaActionPerformed(ActionEvent evt) {
        if (this.jrbXML.isSelected()) {
            int returnVal = this.fc1.showOpenDialog(this.getParent());
            if (returnVal == 0) {
                this.jtfFEntrada.setText(this.fc1.getSelectedFile().getAbsolutePath());
            }
        } else {
            this.recuperaSubs();
        }
    }

    private void jbutFSortidaActionPerformed(ActionEvent evt) {
        int returnVal = this.fc2.showSaveDialog(this.getParent());
        if (returnVal == 0) {
            this.jtfFSortida.setText(this.fc2.getSelectedFile().getAbsolutePath());
        }
    }

    private void jbutCatalaActionPerformed(ActionEvent evt) {
        this.canviIdioma(tIdioma.ca);
    }

    private void jbutCastellaActionPerformed(ActionEvent evt) {
        this.canviIdioma(tIdioma.es);
    }

    private void jbutAnglesActionPerformed(ActionEvent evt) {
        this.canviIdioma(tIdioma.en);
    }

    private void jtfFEntradaFocusGained(FocusEvent evt) {
        this.jtfFEntrada.selectAll();
    }

    private void jcbInvertirActionPerformed(ActionEvent evt) {
        this.jcbInvertir.setSelected(false);
        Object[][] data = this.tablemodel.getData();
        if (data == null) {
            return;
        }
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = new Boolean((Boolean)data[i][0] == false);
        }
        this.tablemodel = new TableModel(this.bundle);
        this.tablemodel.init(this.lSubs, data);
        this.jtLlistaSubtitols.setModel(this.tablemodel);
    }

    private void jcbTotActionPerformed(ActionEvent evt) {
        Object[][] data = this.tablemodel.getData();
        if (data == null) {
            return;
        }
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = new Boolean(this.jcbTot.isSelected());
        }
        this.tablemodel = new TableModel(this.bundle);
        this.tablemodel.init(this.lSubs, data);
        this.jtLlistaSubtitols.setModel(this.tablemodel);
    }

    private void jrbURLItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.defaultFile = this.jtfFEntrada.getText();
            this.jtfFEntrada.setText(this.defaultURL);
            this.jbutFEntrada.setText(this.bundle.getString("GUI.jbutFEntrada.text"));
            this.jbutFEntrada.setToolTipText(this.bundle.getString("GUI.jbutFEntrada.toolTipText"));
        }
    }

    private void jrbXMLItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.lSubs = null;
            this.defaultURL = this.jtfFEntrada.getText();
            this.jtfFEntrada.setText(this.defaultFile);
            this.jbutFEntrada.setText(this.bundle.getString("GUI.jbutFEntrada.xmlfile.text"));
            this.jbutFEntrada.setToolTipText(this.bundle.getString("GUI.jbutFEntrada.xmlfile.toolTipText"));
        }
    }

    private void jtfFEntradaMousePressed(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.jtfFEntrada.requestFocusInWindow();
        }
    }

    private void jtfFSortidaMousePressed(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.jtfFSortida.requestFocusInWindow();
        }
    }

    private void jbutBrasilerActionPerformed(ActionEvent evt) {
        this.canviIdioma(tIdioma.pt_BR);
    }

    private void jbutItaliaActionPerformed(ActionEvent evt) {
        this.canviIdioma(tIdioma.it);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new GUI().setVisible(true);
            }
        });
    }

    public void msgFormatEntradaNoValid() {
        String msg = this.bundle.getString("msg.infile.invalid.format");
        this.jtfFEntrada.requestFocusInWindow();
        JOptionPane.showMessageDialog(null, msg);
    }

    public void msgIOException() {
        String msg = this.bundle.getString("msg.io.error");
        this.jtfFEntrada.requestFocusInWindow();
        JOptionPane.showMessageDialog(null, msg);
    }

    public void msgFitxerNoSubtitols() {
        String msg = this.bundle.getString("msg.infile.no.subtitles.found");
        this.jtfFEntrada.requestFocusInWindow();
        JOptionPane.showMessageDialog(null, msg);
    }

    public void msgConversioOk() {
        String msg = this.bundle.getString("msg.convesion.done.ok");
        this.jtfFEntrada.requestFocusInWindow();
        JOptionPane.showMessageDialog(null, msg);
    }

    public void msgConversioFi() {
        String msg = this.bundle.getString("msg.convesion.finished");
        this.jtfFEntrada.requestFocusInWindow();
        JOptionPane.showMessageDialog(null, msg);
    }

    public void msgConversioErrors() {
        String msg = this.bundle.getString("msg.convesion.done.error");
        this.jtfFEntrada.requestFocusInWindow();
        JOptionPane.showMessageDialog(null, msg);
    }

    public void preparaNova() {
        this.jbutConvertir.setEnabled(true);
        this.jlEstat.setText("");
    }

    public void recuperaSubs() {
        this.lSubs = null;
        this.jcbTot.setSelected(false);
        try {
            this.jlEstat.setText(this.bundle.getString("msg.status.connecting"));
            this.lSubs = Network.getSubtitles(this.jtfFEntrada.getText());
            this.jlEstat.setText("");
        }
        catch (Network.HostNoGV e) {
            String msg = this.bundle.getString("msg.url.unknown.host");
            this.jtfFEntrada.requestFocusInWindow();
            JOptionPane.showMessageDialog(null, msg);
            this.preparaNova();
            return;
        }
        catch (Network.NoDocId e) {
            String msg = this.bundle.getString("msg.url.parameter.docid.not.found");
            this.jtfFEntrada.requestFocusInWindow();
            JOptionPane.showMessageDialog(null, msg);
            this.preparaNova();
            return;
        }
        catch (Network.NoQuery e) {
            String msg = this.bundle.getString("msg.url.parameter.not.found");
            this.jtfFEntrada.requestFocusInWindow();
            JOptionPane.showMessageDialog(null, msg);
            this.preparaNova();
            return;
        }
        catch (Network.DocIdInvalid e) {
            String msg = this.bundle.getString("msg.url.parameter.docid.invalid");
            this.jtfFEntrada.requestFocusInWindow();
            JOptionPane.showMessageDialog(null, msg);
            this.preparaNova();
            return;
        }
        catch (Network.NoSubs e) {
            this.msgFitxerNoSubtitols();
            this.preparaNova();
            return;
        }
        catch (MalformedURLException e) {
            String msg = this.bundle.getString("msg.url.invalid.format");
            this.jtfFEntrada.requestFocusInWindow();
            JOptionPane.showMessageDialog(null, msg);
            this.preparaNova();
            return;
        }
        catch (JDOMParseException e) {
            String msg = this.bundle.getString("msg.url.unexpected.format");
            this.jtfFEntrada.requestFocusInWindow();
            JOptionPane.showMessageDialog(null, msg);
            this.preparaNova();
            return;
        }
        catch (UnknownHostException e) {
            String msg = this.bundle.getString("msg.net.unknown.host");
            this.jtfFEntrada.requestFocusInWindow();
            JOptionPane.showMessageDialog(null, msg);
            this.preparaNova();
            return;
        }
        catch (FileNotFoundException e) {
            String msg = this.bundle.getString("msg.url.does.not.exist");
            this.jtfFEntrada.requestFocusInWindow();
            JOptionPane.showMessageDialog(null, msg);
            this.preparaNova();
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = this.bundle.getString("msg.unknown.error");
            this.jtfFEntrada.requestFocusInWindow();
            JOptionPane.showMessageDialog(null, msg);
            this.preparaNova();
            return;
        }
        this.tablemodel = new TableModel(this.bundle);
        if (this.lSubs != null) {
            Object[][] data = this.tablemodel.getData();
            if (data != null) {
                this.tablemodel.init(this.lSubs, data);
            } else {
                this.tablemodel.init(this.lSubs);
            }
        }
        this.jtLlistaSubtitols.setModel(this.tablemodel);
        this.preparaNova();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum tIdioma {
        ca,
        es,
        en,
        pt_BR,
        it;

    }
}

